#A) Modello con gerarchia ma mistura nei parametri



#Descrizione: modello mistura di tipo "B" (Stuart). Sta a indicare una mistura non delle
# distribuzioni, ma nei parametri. Forse overparametrizzato.


# y_{m1}~Poisson(ptheta1+(1-p)lambda1)
# y_{m2}~Poisson(ptheta2+(1-p)lambda2)

#Jags


dati_serieA<-list(nteams=nteams_serieA,
                          ngames_train=ngames_train_serieA,
                          ngames_test=ngames_test_serieA,
                          team1=team1_serieA,
                          score1=score1_serieA,
                          team2=team2_serieA,
                          score2=score2_serieA,
                          team1_prev=team1_prev_serieA,
                          team2_prev=team2_prev_serieA,
                          theta1_bm_mean=book_serieA$theta1_bm_mean,
                          theta2_bm_mean=book_serieA$theta2_bm_mean,
                          theta1_bm_mean_prev=book_serieA$theta1_bm_mean_prev,
                          theta2_bm_mean_prev=book_serieA$theta2_bm_mean_prev,
                          theta1_bm=book_serieA$theta1_bm,
                          theta2_bm=book_serieA$theta2_bm,                   
                          theta1_bm_prev=book_serieA$theta1_bm_prev,
                          theta2_bm_prev=book_serieA$theta2_bm_prev,
                          onesRepNclust_and=rep(1,2),
                          onesRepNclust_prev=rep(1,2),
                          T=T,
                          season=season_serieA,
                          season_prev=season_prev_serieA,
                          agenzie=agenzie)


dati_PL<-list(nteams=nteams_PL,
                  ngames_train=ngames_train_PL,
                  ngames_test=ngames_test_PL,
                  team1=team1_PL,
                  score1=score1_PL,
                  team2=team2_PL,
                  score2=score2_PL,
                  team1_prev=team1_prev_PL,
                  team2_prev=team2_prev_PL,
                  theta1_bm_mean=book_PL$theta1_bm_mean,
                  theta2_bm_mean=book_PL$theta2_bm_mean,
                  theta1_bm_mean_prev=book_PL$theta1_bm_mean_prev,
                  theta2_bm_mean_prev=book_PL$theta2_bm_mean_prev,
                  theta1_bm=book_PL$theta1_bm,
                  theta2_bm=book_PL$theta2_bm,                   
                  theta1_bm_prev=book_PL$theta1_bm_prev,
                  theta2_bm_prev=book_PL$theta2_bm_prev,
                  onesRepNclust_and=rep(1,2),
                  onesRepNclust_prev=rep(1,2),
                  T=T,
                  season=season_PL,
                  season_prev=season_prev_PL,
                  agenzie=agenzie)

dati_Liga<-list(nteams=nteams_Liga,
                  ngames_train=ngames_train_Liga,
                  ngames_test=ngames_test_Liga,
                  team1=team1_Liga,
                  score1=score1_Liga,
                  team2=team2_Liga,
                  score2=score2_Liga,
                  team1_prev=team1_prev_Liga,
                  team2_prev=team2_prev_Liga,
                  theta1_bm_mean=book_Liga$theta1_bm_mean,
                  theta2_bm_mean=book_Liga$theta2_bm_mean,
                  theta1_bm_mean_prev=book_Liga$theta1_bm_mean_prev,
                  theta2_bm_mean_prev=book_Liga$theta2_bm_mean_prev,
                  theta1_bm=book_Liga$theta1_bm,
                  theta2_bm=book_Liga$theta2_bm,                   
                  theta1_bm_prev=book_Liga$theta1_bm_prev,
                  theta2_bm_prev=book_Liga$theta2_bm_prev,
                  onesRepNclust_and=rep(1,2),
                  onesRepNclust_prev=rep(1,2),
                  T=T,
                  season=season_Liga,
                  season_prev=season_prev_Liga,
                  agenzie=agenzie)

dati_BundesLiga<-list(nteams=nteams_BundesLiga,
                  ngames_train=ngames_train_BundesLiga,
                  ngames_test=ngames_test_BundesLiga,
                  team1=team1_BundesLiga,
                  score1=score1_BundesLiga,
                  team2=team2_BundesLiga,
                  score2=score2_BundesLiga,
                  team1_prev=team1_prev_BundesLiga,
                  team2_prev=team2_prev_BundesLiga,
                  theta1_bm_mean=book_BundesLiga$theta1_bm_mean,
                  theta2_bm_mean=book_BundesLiga$theta2_bm_mean,
                  theta1_bm_mean_prev=book_BundesLiga$theta1_bm_mean_prev,
                  theta2_bm_mean_prev=book_BundesLiga$theta2_bm_mean_prev,
                  theta1_bm=book_BundesLiga$theta1_bm,
                  theta2_bm=book_BundesLiga$theta2_bm,                   
                  theta1_bm_prev=book_BundesLiga$theta1_bm_prev,
                  theta2_bm_prev=book_BundesLiga$theta2_bm_prev,
                  onesRepNclust_and=rep(1,2),
                  onesRepNclust_prev=rep(1,2),
                  T=T,
                  season=season_BundesLiga,
                  season_prev=season_prev_BundesLiga,
                  agenzie=agenzie)


mod<-"model{
# Likelihood:

for (n in 1:ngames_train){
  for (s in 1:agenzie){

      # dlnorm distribution, comment 5

      theta1_bm[n,s] ~  dlnorm(lambda1_book[n], tau1_book)   
      theta2_bm[n,s] ~  dlnorm(lambda2_book[n], tau2_book)
 }

      theta1_hat[n] <- pClust1[n,1]*thetaofClust[n,1,1] +
                            pClust1[n,2]*thetaofClust[n,1,2]
      theta2_hat[n] <- pClust1[n,1]*thetaofClust[n,2,1] +
                            pClust1[n,2]*thetaofClust[n,2,2]
      
      score1[n] ~ dpois(theta1_hat[n])
      score2[n] ~ dpois(theta2_hat[n])

# Average Scoring intensities (accounting for mixing components)

      pClust1[n,1:2] ~ ddirch(onesRepNclust_and[1:2])
      #pClust2[n,1:2] ~ ddirch(onesRepNclust_and[1:2])

    log(thetaofClust[n,1,1])<-m+home+
                  att[team1[n], season[n]]+def[team2[n], season[n]]
    log(thetaofClust[n,1,2])<-log(lambda1_book[n])
    log(thetaofClust[n,2,1])<-m+
                  att[team2[n], season[n]]+def[team1[n], season[n]]
    log(thetaofClust[n,2,2])<-log(lambda2_book[n])

#priors for lambda1_book, lambda2_book

      lambda1_book[n]~ dlnorm(theta1_bm_mean[n], 0.01)
      lambda2_book[n]~ dlnorm(theta2_bm_mean[n], 0.01)
}

# Predictive distribution for the number of goals scored

for (n in 1:ngames_test){
    for (s in 1:agenzie){

      theta1_bm_prev[n,s] ~ dlnorm(lambda1_book_prev[n], tau1_book)
      theta2_bm_prev[n,s] ~ dlnorm(lambda2_book_prev[n], tau2_book)
 }


  theta1_hat_prev[n] <- pClust1_prev[n,1]*thetaofClust_prev[n,1,1]+ 
                 pClust1_prev[n,2]*thetaofClust_prev[n,1,2]

  theta2_hat_prev[n] <- pClust1_prev[n,1]*thetaofClust_prev[n,2,1]+                  pClust1_prev[n,2]*thetaofClust_prev[n,2,2]
  score1_prev[n] ~ dpois(theta1_hat_prev[n])
  score2_prev[n] ~ dpois(theta2_hat_prev[n])

  pClust1_prev[n,1:2] ~ ddirch(onesRepNclust_prev[1:2])
  #pClust2_prev[n,1:2] ~ ddirch(onesRepNclust_prev[1:2])

  log(thetaofClust_prev[n,1,1]) <- m+home+
                          att[team1_prev[n], season_prev[n]]+
                                 def[team2_prev[n], season_prev[n]]
  log(thetaofClust_prev[n,1,2]) <- log(lambda1_book_prev[n])
  log(thetaofClust_prev[n,2,1]) <- m+
                          att[team2_prev[n], season_prev[n]]+
                                 def[team1_prev[n], season_prev[n]]
  log(thetaofClust_prev[n,2,2]) <- log(lambda2_book_prev[n])

#prior for lambda1_book, lambda2_book


      lambda1_book_prev[n] ~ dlnorm(theta1_bm_mean_prev[n], 0.01)
      lambda2_book_prev[n] ~ dlnorm(theta2_bm_mean_prev[n], 0.01)
}

# Prior: BASIC MODEL FOR HYPERPARAMETERS
  for (t in 1:nteams){

          att.star[t,1] ~ dnorm(mu.att, tau.att)
          def.star[t,1] ~ dnorm(mu.def, tau.def)

          att[t,1] <- att.star[t,1] - mean(att.star[,1])
          def[t,1] <- def.star[t,1] - mean(def.star[,1])

       for (h in 2:T){

              att.star[t,h] ~ dnorm(mu.att+att.star[t,h-1],tau.att)
              def.star[t,h] ~ dnorm(mu.def+def.star[t,h-1],tau.def)

              att[t,h] <- att.star[t,h] - mean(att.star[,h])
              def[t,h] <- def.star[t,h] - mean(def.star[,h])
    }
  }

# priors on the random effects

    mu.att ~ dnorm(0,0.0001)
    mu.def ~ dnorm(0,0.0001)
    tau.att ~ dgamma(.01,.01)
    tau.def ~ dgamma(.01,.01) 
    m ~ dnorm(0,0.0001)
    tau1_book <- pow(sigma1.y,-2)
    tau2_book <- pow(sigma2.y,-2)
    sigma1.y ~ dunif(0,10)
    sigma2.y ~ dunif(0,10)
    home ~ dnorm(0,0.0001)
}"


moni<- c("thetaofClust", "pClust1", 
  #"pClust2",
         "score1_prev", "score2_prev",
         "att","def", "sigma1.y", "sigma2.y", 
         "theta1_hat", "theta2_hat", "theta1_hat_prev", 
  "theta2_hat_prev", "home", "m",
         "dic", "deviance")

init_serieA1<- list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1),
  home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_serieA, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_serieA, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_serieA, 0,3),
  lambda2_book_prev=runif(ngames_test_serieA, 0,3),
  lambda1_book=runif(ngames_train_serieA, 0,3),
  lambda2_book=runif(ngames_train_serieA, 0,3))

init_serieA2<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1),
  home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_serieA, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_serieA, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_serieA, 0,3),
  lambda2_book_prev=runif(ngames_test_serieA, 0,3),
  lambda1_book=runif(ngames_train_serieA, 0,3),
  lambda2_book=runif(ngames_train_serieA, 0,3))

init_serieA3<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), 
  home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_serieA, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_serieA, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_serieA, 0,3),
  lambda2_book_prev=runif(ngames_test_serieA, 0,3),
  lambda1_book=runif(ngames_train_serieA, 0,3),
  lambda2_book=runif(ngames_train_serieA, 0,3))

library(parallel)
cl <- makeCluster(3)


serieA.jags<- run.jags(model=mod, data=dati_serieA, 
                       monitor=moni, 
                       inits=list(init_serieA1, 
                       init_serieA2, init_serieA3), 
                       n.chains=3, 
                       method="rjags",
                       plots=FALSE, thin=2,adapt=A, 
                       sample=M, burnin=B)


fine=date()

ris.serieA=serieA.jags$mcmc[[1]]
fattori_att_serieA<-ris.serieA[,grep("att[",colnames(ris.serieA),fixed=TRUE)] 
fattori_def_serieA<-ris.serieA[,grep("def[",colnames(ris.serieA),fixed=TRUE)]
previsioni1_serieA<-ris.serieA[,grep("score1_prev[",colnames(ris.serieA),fixed=TRUE)] 
previsioni2_serieA<-ris.serieA[,grep("score2_prev[",colnames(ris.serieA),fixed=TRUE)] 
theta1_book_serieA<-ris.serieA[,grep("theta1_book[",colnames(ris.serieA),fixed=TRUE)] 
theta2_book_serieA<-ris.serieA[,grep("theta2_book[",colnames(ris.serieA),fixed=TRUE)] 
theta1_book_prev_serieA<-ris.serieA[,grep("theta1_book_prev",colnames(ris.serieA),fixed=TRUE)] 
theta2_book_prev_serieA<-ris.serieA[,grep("theta2_book_prev",colnames(ris.serieA),fixed=TRUE)] 
gruppo_serieA<-ris.serieA[,grep("clust[",colnames(ris.serieA),fixed=TRUE)] 
sigma1.y_serieA<-ris.serieA[,grep("sigma1.y[",colnames(ris.serieA),fixed=TRUE)] 
sigma2.y_serieA<-ris.serieA[,grep("sigma2.y[",colnames(ris.serieA),fixed=TRUE)] 
pClust1_serieA<-ris.serieA[,grep("pClust1[",colnames(ris.serieA),fixed=TRUE)] 
pClust2_serieA<-ris.serieA[,grep("pClust2[",colnames(ris.serieA),fixed=TRUE)] 
alpha_serieA<-ris.serieA[,grep("alpha",colnames(ris.serieA),fixed=TRUE)] 
beta_serieA<-ris.serieA[,grep("beta",colnames(ris.serieA),fixed=TRUE)] 
b_serieA<-ris.serieA[,grep("b_par",colnames(ris.serieA),fixed=TRUE)] 
c_serieA<-ris.serieA[,grep("c_par",colnames(ris.serieA),fixed=TRUE)] 
d_serieA<-ris.serieA[,grep("d_par",colnames(ris.serieA),fixed=TRUE)] 
mu_serieA<-ris.serieA[,grep("m",colnames(ris.serieA),fixed=TRUE)] 
home_serieA<-ris.serieA[,grep("m",colnames(ris.serieA),fixed=TRUE)] 

theta1_hat_serieA<-ris.serieA[,grep("theta1_hat[",colnames(ris.serieA),fixed=TRUE)] 
theta2_hat_serieA<-ris.serieA[,grep("theta2_hat[",colnames(ris.serieA),fixed=TRUE)] 
theta1_hat_prev_serieA<-ris.serieA[,grep("theta1_hat_prev[",colnames(ris.serieA),fixed=TRUE)] 
theta2_hat_prev_serieA<-ris.serieA[,grep("theta2_hat_prev[",colnames(ris.serieA),fixed=TRUE)] 
hat_theta1_serieA=apply(theta1_hat_serieA,2,mean)
hat_theta2_serieA=apply(theta2_hat_serieA,2,mean)
hat_theta1_prev_serieA=apply(theta1_hat_prev_serieA,2,mean)
hat_theta2_prev_serieA=apply(theta2_hat_prev_serieA,2,mean)
hat_theta1_serieA=as.vector(hat_theta1_serieA)
hat_theta2_serieA=as.vector(hat_theta2_serieA)
hat_theta1_prev_serieA=as.vector(hat_theta1_prev_serieA)
hat_theta2_prev_serieA=as.vector(hat_theta2_prev_serieA)





init_PL1<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), 
  home=rnorm(1),
 tau.att=runif(1), tau.def=runif(1), 
 pClust1=matrix(rep(1/2,2), ngames_train_PL, 2, byrow=TRUE),
 pClust1_prev=matrix(rep(1/2,2), ngames_test_PL, 2, byrow=TRUE),
 sigma1.y=runif(1), sigma2.y=runif(1),
 lambda1_book_prev=runif(ngames_test_PL, 0,3),
 lambda2_book_prev=runif(ngames_test_PL, 0,3),
 lambda1_book=runif(ngames_train_PL, 0,3),
 lambda2_book=runif(ngames_train_PL, 0,3))

init_PL2<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), 
  home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1), 
  pClust1=matrix(rep(1/2,2), ngames_train_PL, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_PL, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_PL, 0,3),
  lambda2_book_prev=runif(ngames_test_PL, 0,3),
  lambda1_book=runif(ngames_train_PL, 0,3),
  lambda2_book=runif(ngames_train_PL, 0,3))

init_PL3<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), 
  home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1), 
  pClust1=matrix(rep(1/2,2), ngames_train_PL, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_PL, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_PL, 0,3),
  lambda2_book_prev=runif(ngames_test_PL, 0,3),
  lambda1_book=runif(ngames_train_PL, 0,3),
  lambda2_book=runif(ngames_train_PL, 0,3))



PL.jags<- run.jags(model=mod, data=dati_PL, 
                       monitor=moni, 
                       inits=list(init_PL1,init_PL2, init_PL3), 
                       n.chains=3, 
                       method="rjags",
                       plots=FALSE, thin=2, 
                       adapt=A, sample=M, burnin=B)


fine=date()

ris.PL=PL.jags$mcmc[[1]]
fattori_att_PL<-ris.PL[,grep("att[",colnames(ris.PL),fixed=TRUE)] 
fattori_def_PL<-ris.PL[,grep("def[",colnames(ris.PL),fixed=TRUE)]
previsioni1_PL<-ris.PL[,grep("score1_prev[",colnames(ris.PL),fixed=TRUE)] 
previsioni2_PL<-ris.PL[,grep("score2_prev[",colnames(ris.PL),fixed=TRUE)] 
theta1_book_PL<-ris.PL[,grep("theta1_book[",colnames(ris.PL),fixed=TRUE)] 
theta2_book_PL<-ris.PL[,grep("theta2_book[",colnames(ris.PL),fixed=TRUE)] 
theta1_book_prev_PL<-ris.PL[,grep("theta1_book_prev",colnames(ris.PL),fixed=TRUE)] 
theta2_book_prev_PL<-ris.PL[,grep("theta2_book_prev",colnames(ris.PL),fixed=TRUE)] 
gruppo_PL<-ris.PL[,grep("clust[",colnames(ris.PL),fixed=TRUE)] 
sigma1.y_PL<-ris.PL[,grep("sigma1.y[",colnames(ris.PL),fixed=TRUE)] 
sigma2.y_PL<-ris.PL[,grep("sigma2.y[",colnames(ris.PL),fixed=TRUE)] 
pClust1_PL<-ris.PL[,grep("pClust1[",colnames(ris.PL),fixed=TRUE)] 
pClust2_PL<-ris.PL[,grep("pClust2[",colnames(ris.PL),fixed=TRUE)] 
alpha_PL<-ris.PL[,grep("alpha",colnames(ris.PL),fixed=TRUE)] 
beta_PL<-ris.PL[,grep("beta",colnames(ris.PL),fixed=TRUE)] 
b_PL<-ris.PL[,grep("b_par",colnames(ris.PL),fixed=TRUE)] 
c_PL<-ris.PL[,grep("c_par",colnames(ris.PL),fixed=TRUE)] 
d_PL<-ris.PL[,grep("d_par",colnames(ris.PL),fixed=TRUE)] 
mu_PL<-ris.PL[,grep("mu",colnames(ris.PL),fixed=TRUE)] 

theta1_hat_PL<-ris.PL[,grep("theta1_hat[",colnames(ris.PL),fixed=TRUE)] 
theta2_hat_PL<-ris.PL[,grep("theta2_hat[",colnames(ris.PL),fixed=TRUE)] 
theta1_hat_prev_PL<-ris.PL[,grep("theta1_hat_prev[",colnames(ris.PL),fixed=TRUE)] 
theta2_hat_prev_PL<-ris.PL[,grep("theta2_hat_prev[",colnames(ris.PL),fixed=TRUE)] 
hat_theta1_PL=apply(theta1_hat_PL,2,mean)
hat_theta2_PL=apply(theta2_hat_PL,2,mean)
hat_theta1_prev_PL=apply(theta1_hat_prev_PL,2,mean)
hat_theta2_prev_PL=apply(theta2_hat_prev_PL,2,mean)
hat_theta1_PL=as.vector(hat_theta1_PL)
hat_theta2_PL=as.vector(hat_theta2_PL)
hat_theta1_prev_PL=as.vector(hat_theta1_prev_PL)
hat_theta2_prev_PL=as.vector(hat_theta2_prev_PL)




init_Liga1<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), 
  home=rnorm(1),
            tau.att=runif(1), tau.def=runif(1),
            pClust1=matrix(rep(1/2,2), 
              ngames_train_Liga, 2, byrow=TRUE),
            sigma1.y=runif(1), sigma2.y=runif(1),
            lambda1_book_prev=runif(ngames_test_Liga, 0,3),
            lambda2_book_prev=runif(ngames_test_Liga, 0,3),
            lambda1_book=runif(ngames_train_Liga, 0,3),
            lambda2_book=runif(ngames_train_Liga, 0,3))

init_Liga2<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), 
  home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_Liga, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_Liga, 0,3),
  lambda2_book_prev=runif(ngames_test_Liga, 0,3),
  lambda1_book=runif(ngames_train_Liga, 0,3),
  lambda2_book=runif(ngames_train_Liga, 0,3))

init_Liga3<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), 
  home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_Liga, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_Liga, 0,3),
  lambda2_book_prev=runif(ngames_test_Liga, 0,3),
  lambda1_book=runif(ngames_train_Liga, 0,3),
  lambda2_book=runif(ngames_train_Liga, 0,3))



Liga.jags<- run.jags(model=mod, data=dati_Liga, 
                       monitor=moni, 
                       inits=list(init_Liga1,init_Liga2, 
                         init_Liga3),
                       n.chains=3, 
                       method="rjags",
                       plots=FALSE, thin=2, adapt=A, sample=M, 
                       burnin=B, cl = cl)


fine=date()

ris.Liga=Liga.jags$mcmc[[1]]
fattori_att_Liga<-ris.Liga[,grep("att[",colnames(ris.Liga),fixed=TRUE)] 
fattori_def_Liga<-ris.Liga[,grep("def[",colnames(ris.Liga),fixed=TRUE)]
previsioni1_Liga<-ris.Liga[,grep("score1_prev[",colnames(ris.Liga),fixed=TRUE)] 
previsioni2_Liga<-ris.Liga[,grep("score2_prev[",colnames(ris.Liga),fixed=TRUE)] 
theta1_book_Liga<-ris.Liga[,grep("theta1_book[",colnames(ris.Liga),fixed=TRUE)] 
theta2_book_Liga<-ris.Liga[,grep("theta2_book[",colnames(ris.Liga),fixed=TRUE)] 
theta1_book_prev_Liga<-ris.Liga[,grep("theta1_book_prev",colnames(ris.Liga),fixed=TRUE)] 
theta2_book_prev_Liga<-ris.Liga[,grep("theta2_book_prev",colnames(ris.Liga),fixed=TRUE)] 
gruppo_Liga<-ris.Liga[,grep("clust[",colnames(ris.Liga),fixed=TRUE)] 
sigma1.y_Liga<-ris.Liga[,grep("sigma1.y[",colnames(ris.Liga),fixed=TRUE)] 
sigma2.y_Liga<-ris.Liga[,grep("sigma2.y[",colnames(ris.Liga),fixed=TRUE)] 
pClust1_Liga<-ris.Liga[,grep("pClust1[",colnames(ris.Liga),fixed=TRUE)] 
pClust2_Liga<-ris.Liga[,grep("pClust2[",colnames(ris.Liga),fixed=TRUE)] 
alpha_Liga<-ris.Liga[,grep("alpha",colnames(ris.Liga),fixed=TRUE)] 
beta_Liga<-ris.Liga[,grep("beta",colnames(ris.Liga),fixed=TRUE)] 
b_Liga<-ris.Liga[,grep("b_par",colnames(ris.Liga),fixed=TRUE)] 
c_Liga<-ris.Liga[,grep("c_par",colnames(ris.Liga),fixed=TRUE)] 
d_Liga<-ris.Liga[,grep("d_par",colnames(ris.Liga),fixed=TRUE)] 
mu_Liga<-ris.Liga[,grep("mu",colnames(ris.Liga),fixed=TRUE)] 

theta1_hat_Liga<-ris.Liga[,grep("theta1_hat[",colnames(ris.Liga),fixed=TRUE)] 
theta2_hat_Liga<-ris.Liga[,grep("theta2_hat[",colnames(ris.Liga),fixed=TRUE)] 
theta1_hat_prev_Liga<-ris.Liga[,grep("theta1_hat_prev[",colnames(ris.Liga),fixed=TRUE)] 
theta2_hat_prev_Liga<-ris.Liga[,grep("theta2_hat_prev[",colnames(ris.Liga),fixed=TRUE)] 
hat_theta1_Liga=apply(theta1_hat_Liga,2,mean)
hat_theta2_Liga=apply(theta2_hat_Liga,2,mean)
hat_theta1_prev_Liga=apply(theta1_hat_prev_Liga,2,mean)
hat_theta2_prev_Liga=apply(theta2_hat_prev_Liga,2,mean)
hat_theta1_Liga=as.vector(hat_theta1_Liga)
hat_theta2_Liga=as.vector(hat_theta2_Liga)
hat_theta1_prev_Liga=as.vector(hat_theta1_prev_Liga)
hat_theta2_prev_Liga=as.vector(hat_theta2_prev_Liga)





init_BundesLiga1<-list(mu.att=rnorm(1), mu.def=rnorm(1), 
  m=rnorm(1), home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_BundesLiga, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_BundesLiga, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_BundesLiga, 0,3),
  lambda2_book_prev=runif(ngames_test_BundesLiga, 0,3),
  lambda1_book=runif(ngames_train_BundesLiga, 0,3),
  lambda2_book=runif(ngames_train_BundesLiga, 0,3))

init_BundesLiga2<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_BundesLiga, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_BundesLiga, 2, byrow=TRUE),
  sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_BundesLiga, 0,3),
  lambda2_book_prev=runif(ngames_test_BundesLiga, 0,3),
  lambda1_book=runif(ngames_train_BundesLiga, 0,3),
  lambda2_book=runif(ngames_train_BundesLiga, 0,3))

init_BundesLiga3<-list(mu.att=rnorm(1), mu.def=rnorm(1), m=rnorm(1), home=rnorm(1),
  tau.att=runif(1), tau.def=runif(1),
  pClust1=matrix(rep(1/2,2), ngames_train_BundesLiga, 2, byrow=TRUE),
  pClust1_prev=matrix(rep(1/2,2), ngames_test_BundesLiga, 2, byrow=TRUE),sigma1.y=runif(1), sigma2.y=runif(1),
  lambda1_book_prev=runif(ngames_test_BundesLiga, 0,3),
  lambda2_book_prev=runif(ngames_test_BundesLiga, 0,3),
  lambda1_book=runif(ngames_train_BundesLiga, 0,3),
  lambda2_book=runif(ngames_train_BundesLiga, 0,3))



BundesLiga.jags<- run.jags(model=mod, data=dati_BundesLiga, 
                       monitor=moni, 
                       inits=list(init_BundesLiga1,init_BundesLiga2,
                         init_BundesLiga3),
                       n.chains=3, 
                       method="rjags",
                       plots=FALSE, thin=2,adapt=A, 
                       sample=M, burnin=B)


fine=date()

ris.BundesLiga=BundesLiga.jags$mcmc[[1]]
fattori_att_BundesLiga<-ris.BundesLiga[,grep("att[",colnames(ris.BundesLiga),fixed=TRUE)] 
fattori_def_BundesLiga<-ris.BundesLiga[,grep("def[",colnames(ris.BundesLiga),fixed=TRUE)]
previsioni1_BundesLiga<-ris.BundesLiga[,grep("score1_prev[",colnames(ris.BundesLiga),fixed=TRUE)] 
previsioni2_BundesLiga<-ris.BundesLiga[,grep("score2_prev[",colnames(ris.BundesLiga),fixed=TRUE)] 
theta1_book_BundesLiga<-ris.BundesLiga[,grep("theta1_book[",colnames(ris.BundesLiga),fixed=TRUE)] 
theta2_book_BundesLiga<-ris.BundesLiga[,grep("theta2_book[",colnames(ris.BundesLiga),fixed=TRUE)] 
theta1_book_prev_BundesLiga<-ris.BundesLiga[,grep("theta1_book_prev",colnames(ris.BundesLiga),fixed=TRUE)] 
theta2_book_prev_BundesLiga<-ris.BundesLiga[,grep("theta2_book_prev",colnames(ris.BundesLiga),fixed=TRUE)] 
gruppo_BundesLiga<-ris.BundesLiga[,grep("clust[",colnames(ris.BundesLiga),fixed=TRUE)] 
sigma1.y_BundesLiga<-ris.BundesLiga[,grep("sigma1.y[",colnames(ris.BundesLiga),fixed=TRUE)] 
sigma2.y_BundesLiga<-ris.BundesLiga[,grep("sigma2.y[",colnames(ris.BundesLiga),fixed=TRUE)] 
pClust1_BundesLiga<-ris.BundesLiga[,grep("pClust1[",colnames(ris.BundesLiga),fixed=TRUE)] 
pClust2_BundesLiga<-ris.BundesLiga[,grep("pClust2[",colnames(ris.BundesLiga),fixed=TRUE)] 
alpha_BundesLiga<-ris.BundesLiga[,grep("alpha",colnames(ris.BundesLiga),fixed=TRUE)] 
beta_BundesLiga<-ris.BundesLiga[,grep("beta",colnames(ris.BundesLiga),fixed=TRUE)] 
b_BundesLiga<-ris.BundesLiga[,grep("b_par",colnames(ris.BundesLiga),fixed=TRUE)] 
c_BundesLiga<-ris.BundesLiga[,grep("c_par",colnames(ris.BundesLiga),fixed=TRUE)] 
d_BundesLiga<-ris.BundesLiga[,grep("d_par",colnames(ris.BundesLiga),fixed=TRUE)] 
mu_BundesLiga<-ris.BundesLiga[,grep("mu",colnames(ris.BundesLiga),fixed=TRUE)] 

theta1_hat_BundesLiga<-ris.BundesLiga[,grep("theta1_hat[",colnames(ris.BundesLiga),fixed=TRUE)] 
theta2_hat_BundesLiga<-ris.BundesLiga[,grep("theta2_hat[",colnames(ris.BundesLiga),fixed=TRUE)] 
theta1_hat_prev_BundesLiga<-ris.BundesLiga[,grep("theta1_hat_prev[",colnames(ris.BundesLiga),fixed=TRUE)] 
theta2_hat_prev_BundesLiga<-ris.BundesLiga[,grep("theta2_hat_prev[",colnames(ris.BundesLiga),fixed=TRUE)] 
hat_theta1_BundesLiga=apply(theta1_hat_BundesLiga,2,mean)
hat_theta2_BundesLiga=apply(theta2_hat_BundesLiga,2,mean)
hat_theta1_prev_BundesLiga=apply(theta1_hat_prev_BundesLiga,2,mean)
hat_theta2_prev_BundesLiga=apply(theta2_hat_prev_BundesLiga,2,mean)
hat_theta1_BundesLiga=as.vector(hat_theta1_BundesLiga)
hat_theta2_BundesLiga=as.vector(hat_theta2_BundesLiga)
hat_theta1_prev_BundesLiga=as.vector(hat_theta1_prev_BundesLiga)
hat_theta2_prev_BundesLiga=as.vector(hat_theta2_prev_BundesLiga)


#### DIC

DIC_serieA=extract(serieA.jags, "dic")
DIC_PL=extract(PL.jags, "dic")
DIC_Liga=extract(Liga.jags, "dic")
DIC_BundesLiga=extract(BundesLiga.jags, "dic")


## Save the results




